function Results=Main(Data,p,model,maxIter,diff,nMultiStart)

%Main function for estimating OSI model
%For a discussion of the OSI model, see Van Rosmalen, Koning, and Groenen
%(conditionally accepted for publication), Multivariate Behavioral Research
%For any questions or comments, please contact one of the authors. 
%Input:
%Data       Structure array containing the data with:
%           Data.y     nx1 vector of observations
%           Data.Dat   nxm matrix of categorical predictor variables
%           Data.V     mxm matrix that specifies which interaction effects
%           are modeled. V(i,j)=1 if the interaction between predictor
%           variables i and j must be modeled, and V(i,j)=0 otherwise.
%           Data.dist  String specifying the error distribution, see below for a
%           list of possible distributions. 
%           Data.link  String specifying the link function, see below for a
%           list of possible link functions.
%           Distributions (Data.dist):
%               binoml  is binomial
%               gamma   is gamma
%               inv_gsn is inverse Gaussian
%               normal  is normal
%               poisson is Poisson
%           Link functions (Data.link):
%               id      is identity
%               log     is logarithm
%               logit   is logistic
%               probit  is probit
%               A power transformation can be used by specifying Data.link
%               as a real number. This number is then the power used in a
%               power transformation link function (for example, link=2
%               specifies a quadratic link function).
%p          The dimensionality of the model
%model      The type of model
%               The variable model specifies which model should be used
%               1=main Effects only model
%               2=one-dimensional OSI model
%               3=general multi-dimensional OSI model (equation (9) in
%               Van Rosmalen, Koning, and Groenen (forthcoming))
%               4=restricted multi-dimensional OSI model (equation (11) in
%               Van Rosmalen, Koning, and Groenen (forthcoming))
%               5=restricted multi-dimensional OSI model (equation (12) in
%               Van Rosmalen, Koning, and Groenen (forthcoming))
%               6=restricted multi-dimensional OSI model (equation (13) in
%               Van Rosmalen, Koning, and Groenen (forthcoming))
%               7=Full two-way interaction model
%Output:
%Results        A structure with the estimation results of the OSI model.
%
%Notes:         All multidimensional models (that is, models with p>1) can suffer from identification
%               problems. Therefore, users are advised to only apply models
%               1, 2, and 7 with p=1. Estimation problems can also occur if
%               the data are not appropiate for the chosen link function
%               and error distribution. To test whether the parameters of 
%               the model are properly identified, we advise estimating the
%               model parameters multiple times.
%               If the reported parameters are not the same for two solutions
%               with the same deviance value, the model parameters are not 
%               identified. In such a case, another type of model should be
%               chosen. 
%               These programs cannot estimate multilinear models (that is, models for three-way or
%               higher-way interactions), do not compute confidence intervals 
%               of the parameters, and require that the Optimization
%               toolbox is included in MATLAB. Some files for the
%               distributions and link functions are based on the GLMLAB
%               package made by Peter Dunn

minDeviance=Inf;
for i=1:nMultiStart
    Results=Optimization(Data,p,model,diff,maxIter);             %Estimate model
    if minDeviance>Results.Deviance;
        ResultsTemp=Results;
        minDeviance=Results.Deviance;
    end
end
Results=ResultsTemp;
PrintResults(Data,Results,model);
if model>1 && model<7
    if  p==1                                                     %Show graphical results for the OSI model
        PlotOneDim(Data,Results);
    else
        PlotMultiDim(Data,Results);
    end
end